IF OBJECT_ID('UFD_EXP_CTB_MOV_EST_NF_SAI') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_EST_NF_SAI
	END
	
GO	 
 
CREATE FUNCTION UFD_EXP_CTB_MOV_EST_NF_SAI(@CD_EMP		INT,
										   @CD_FILIAL	INT,
										   @DT_INI		DATETIME,
										   @DT_FIM		DATETIME)		

RETURNS @RS_RETURN TABLE(
		CD_EMP				INT,
		CD_FILIAL			INT,
		DT_CAD				DATETIME,
		DT_EMI_NF			DATETIME,
		CD_DEST				INT,
		NM_DEST				VARCHAR(100),
		HIST				VARCHAR(150),
		VLR_NF				MONEY,
		NF_NF				INT,
		NM_FANT				VARCHAR(100),
		VLR_ICMS_ITENS		MONEY,
		VLR_ICMS_SUBS_ITENS	INT,
		VLR_BASE_PIS_COFINS	MONEY,
		VLR_PIS				MONEY,
		VLR_COFINS			MONEY,
		TP_MOV				INT,
		TP_MOV_DS			VARCHAR(100),
		CD_CTB_CNT			VARCHAR(50),
		CD_CTB_CNT_RED		INT,
		DEST_ORIG			INT,
		CD_MOV_OP			INT)

AS
BEGIN       

	INSERT INTO @RS_RETURN 
		SELECT 
			CD_EMP,
			CD_FILIAL,
			DT_CAD,
			DT_EMI_NF,
			CD_DEST,
			NM_DEST,
			HIST,
			VLR_NF,
			NF_NF,
			NM_FANT,
			VLR_ICMS_ITENS,
			VLR_ICMS_SUBS_ITENS,
			VLR_BASE_PIS_COFINS,
			VLR_PIS,
			VLR_COFINS,
			TP_MOV,
			TP_MOV_DS,			
			CD_CTB_CNT_RED,
			CD_CTB_CNT,
			DEST_ORIG,
			CD_MOV_OP			
		FROM V_EST_NF_SAI_CONTABIL
		WHERE 
			CD_EMP			= @CD_EMP
			AND CD_FILIAL	= @CD_FILIAL
			AND DT_CAD		BETWEEN @DT_INI AND @DT_FIM
			
	RETURN 

END			